<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <link rel="stylesheet" href="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.min.css">

        <style>
            .tab tr td {
                font-size: 16px;
            }

            .tabdetail tr td {
                border-bottom: 1px solid #eaedf0;
            }

            td.inf {
                color: rgb(10, 109, 109);
            }
        </style>
    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-12">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-server text-primary"></i> {{ $data['page'] }}</h3>
                        <form class="form-inline float-right">
                            <input class="form-control mr-sm-2" type="search" placeholder="Search" aria-label="Search"
                                name="cari">
                            <button class="btn btn-primary " type="submit"> <i class="fa fa-search mr-2"></i>
                                Cari!</button>
                        </form>
                    </div>
                    <div class="card-body">
                        <a href="/produk-tambah" class="btn btn-success float-right mb-3"><i
                                class="fa fa-plus-circle mr-2"></i> Produk
                            Baru</a>


                        <div class="btn-group float-right mr-2 mb-3">
                            <button type="button" class="btn btn-info btn-flat">Action</button>
                            <button type="button" class="btn btn-info btn-flat dropdown-toggle dropdown-icon"
                                data-toggle="dropdown">
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <div class="dropdown-menu" role="menu">
                                <a class="dropdown-item" href="#" id="cetak_induk">Cetak Data Induk</a>
                                <a class="dropdown-item" href="/download-format-produk">Download Format</a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="#" data-toggle="modal" data-target="#import">Import
                                    Data Excel</a>
                            </div>
                        </div>

                        <button class="btn btn-default shadow-sm">
                            <div class="icheck-blue d-inline " style="margin-right: -7px">
                                <input type="checkbox" id="cekall">
                                <label for="cekall">
                                </label>
                            </div>
                        </button>
                        <button class="btn btn-danger" id="pilih_hapus"><i class="fa fa-trash"></i> Hapus</button>
                        <button class="btn btn-dark" id="cetak_barcode"><i class="fa fa-print"></i> Cetak
                            Barcode</button>


                        <table class="table table-bordered table-hover myTable tab">
                            <thead>
                                <tr>
                                    <th width="2%">No</th>
                                    <th>#</th>
                                    <th>#</th>
                                    <th>Nama Produk</th>
                                    <th>Berat</th>
                                    <th>Harga Beli</th>
                                    <th>Harga Jual</th>
                                    <th>Stok</th>
                                    <th>Terjual</th>
                                    <th>Satuan Jual</th>
                                    <th>Tgl. Input</th>
                                    <th width="9%">Opsi</th>
                                </tr>
                            </thead>
                            <tbody id="view">
                                @forelse ($produk as $p)
                                    <tr>
                                        <td class="text-center">{{ $no++ }}</td>
                                        <td class="text-center">
                                            <div class="icheck-blue d-inline " style="margin-right: -7px">
                                                <input type="checkbox" name="id[]" id="cek{{ $p->id }}"
                                                    class="ceklis" value="{{ $p->id }}">
                                                <label for="cek{{ $p->id }}">
                                                </label>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            @if ($p->gambar != null)
                                                <img alt="Avatar" class="table-avatar"
                                                    src="{{ asset('/storage/produk/' . $p->gambar) }}" width="40px">
                                            @else
                                                <img alt="Avatar" class="table-avatar"
                                                    src="{{ asset('storage/produk/produk.jpg') }}" width="40px">
                                            @endif
                                        </td>
                                        <td>
                                            {{ $p->nm_produk }} <br>
                                            <small class="text-primary">Kategori :
                                                {{ $p->kategori->nm_kategori }}</small>
                                        </td>
                                        <td>{{ number_format($p->berat, 0, ',', '.') }} Gram</td>
                                        <td class="text-right">{{ number_format($p->harga_beli, 0, ',', '.') }} </td>
                                        <td class="text-center">
                                            @if ($p->diskon == 0)
                                                {{ number_format($p->harga_jual, 0, ',', '.') }}
                                            @else
                                                <del> {{ number_format($p->harga_jual, 0, ',', '.') }}</del>
                                                <small class="text-danger">(Off : {{ $p->diskon }}%)</small>
                                                {{ number_format($p->harga_jual - ($p->harga_jual * $p->diskon) / 100, 0, ',', '.') }}
                                            @endif

                                        </td>
                                        <td class="text-center bg-warning">{{ stok($p->id) - terjual($p->id) }}</td>
                                        <td class="text-center bg-success">{{ terjual($p->id) }}</td>
                                        <td class="text-center ">{{ $p->satuan->nm_satuan }}</td>
                                        <td>{{ tgl_inf($p->created_at) }} </td>
                                        <td class="text-center">
                                            <div class="btn-group" role="group">
                                                <button id="btnGroupDrop1" type="button"
                                                    class="btn btn-primary dropdown-toggle" data-toggle="dropdown"
                                                    aria-haspopup="true" aria-expanded="false">
                                                    <i class="fa fa-edit mr-3"></i>
                                                    Opsi
                                                </button>
                                                <div class="dropdown-menu" aria-labelledby="btnGroupDrop1">
                                                    <a class="dropdown-item"
                                                        href="/produk-edit/{{ $p->link_produk }}">Edit </a>
                                                    <a class="dropdown-item disc" href="#"
                                                        data-id="{{ $p->id }}" data-ds="{{ $p->diskon }}"
                                                        data-nm="{{ $p->nm_produk }}">Edit Diskon</a>
                                                    <a class="dropdown-item gambar" href="#"
                                                        data-id="{{ $p->id }}">Upload Gambar</a>
                                                    <a class="dropdown-item detail" href="#"
                                                        data-id="{{ $p->id }}">Detail</a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="15" class="text-center text-danger"> Data Produk masih
                                            kosong.
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                        {{ $produk->links('components.admin.pagination') }}
                    </div>
                </div>
            </div>


        </div>
        <!-- /.card -->

    </section>

    <div id="hidedata">
        <div class="tampil_data" id="print"></div>
    </div>

    {{-- Upload Gambar --}}
    <div class="modal fade" id="uplgambar">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-primary ">
                    Upload Gambar Produk
                </div>
                <form action="/upload-gambar" method="post" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="id" id="idp">
                    <input type="hidden" name="gbrlama" id="gbrlama">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="">Nama Produk</label>
                            <div class="custom-file">
                                <input type="text" id="nama" class="form-control" readonly>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="">(jpg,jpeg,png)</label>
                            <div class="custom-file">
                                <input type="file" name="gambar" class="custom-file-input"
                                    id="exampleInputFile">
                                <label class="custom-file-label" for="exampleInputFile">Cari
                                    file</label>
                            </div>
                        </div>
                        <div class="form-group d-flex justify-content-center">
                            <div style="height: 180px; width: 40%; border:1px solid  #eaedf0" class="gambar">
                                <div id="gam"></div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary ">Upload Gmabar</button>
                    </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    {{-- Detail --}}
    <div class="modal fade" id="detail">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-primary ">
                    Detail Produk
                </div>
                <div class="modal-body" id="vdetail">
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    {{-- Diskon --}}
    <div class="modal fade" id="diskon">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-primary ">
                    Edit Diskon
                </div>
                <form action="{{ route('produk.diskon') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <label for="">
                            Produk : <span id="nmp"></span> <br>
                        </label> <br>
                        <label for="">Diskon (%)</label>
                        <input type="hidden" name="id" id="idpr" class="form-control">
                        <input type="text" name="diskon" id="disc" class="form-control numbers"
                            placeholder="0%">
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary"><i class="fa fa-save mr-2"></i>
                            Simpan</button>
                    </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    {{-- inport --}}
    <div class="modal fade" id="import">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-primary ">
                    <h4 class="modal-title">Upload Data</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('produk.import') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>PILIH FILE</label>
                            <input type="file" name="file" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary"><i class="fa fa-database mr-1"></i>
                            IMPORT</button>
                    </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>






    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/bs-custom-file-input/bs-custom-file-input.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/produk.js"></script>

    </x-slot:foot>
</x-admin.contents>
